using System;
using System.IO;
using BeWise.SharpBuilderTools;

namespace BeWise.SharpBuilderTools.Ant
{
	public class NAnt: BaseAnt
	{

		// *************************************************************************
		//                           Constructor
		// *************************************************************************

		public NAnt() : base()
		{

		}
		// *************************************************************************
		//                              Protected
		// *************************************************************************

		protected override string GetAntPath () {
			string _Path = Main.Configuration.NAntPath;

			if ((_Path.Length > 0) && (_Path[_Path.Length -1] != '\\')) {
				_Path += @"\";
			}

			return _Path;
		}

		protected override string GetCommandLine ()
		{
			return Consts.NANT_EXE_NAME;
		}

		protected override string GetName ()
		{
			return "NAnt";
		}


		// *************************************************************************
		//                              Public
		// *************************************************************************

		public override BaseAntProject CreateAntProject(string aFileName) {
			return new NAntProject(aFileName);
		}

		public override bool IsAntFile(string aFileName){
			return Path.GetExtension(aFileName).ToUpper() == ".Build".ToUpper();
		}

	}
}
